<?php
/**
 * Güncelleme Sunucusu Yönetim Paneli
 * qr.yusuf.net.tr/admin/index.php
 */

require_once __DIR__ . '/../config.php';

// Giriş işlemi
if (isset($_POST['login'])) {
    if ($_POST['password'] === ADMIN_PASSWORD) {
        $_SESSION['update_admin'] = true;
        header('Location: index.php');
        exit;
    } else {
        $error = 'Yanlış şifre!';
    }
}

// Çıkış
if (isset($_GET['logout'])) {
    unset($_SESSION['update_admin']);
    header('Location: index.php');
    exit;
}

// Yeni güncelleme ekle
if (isAdminLoggedIn() && isset($_POST['add_update'])) {
    $data = getUpdates();
    
    $version = trim($_POST['version']);
    $description = trim($_POST['description']);
    $changelog = trim($_POST['changelog']);
    $isCritical = isset($_POST['is_critical']);
    
    // ZIP yükle
    $filename = '';
    if (!empty($_FILES['update_file']['name'])) {
        $ext = pathinfo($_FILES['update_file']['name'], PATHINFO_EXTENSION);
        if ($ext === 'zip') {
            $filename = 'qrmenu-' . $version . '.zip';
            move_uploaded_file($_FILES['update_file']['tmp_name'], UPDATES_DIR . '/' . $filename);
        }
    }
    
    $newUpdate = [
        'version' => $version,
        'description' => $description,
        'changelog' => $changelog,
        'filename' => $filename,
        'file_size' => !empty($filename) ? filesize(UPDATES_DIR . '/' . $filename) : 0,
        'release_date' => date('Y-m-d H:i:s'),
        'is_critical' => $isCritical,
        'min_php_version' => '7.4'
    ];
    
    // Var olan güncellemeyi güncelle veya yeni ekle
    $found = false;
    foreach ($data['updates'] as $k => $u) {
        if ($u['version'] === $version) {
            $data['updates'][$k] = $newUpdate;
            $found = true;
            break;
        }
    }
    
    if (!$found) {
        $data['updates'][] = $newUpdate;
    }
    
    // Son versiyonu güncelle
    if (versionCompare($version, $data['latest_version']) > 0) {
        $data['latest_version'] = $version;
    }
    
    saveUpdates($data);
    $success = 'Güncelleme eklendi/güncellendi: v' . $version;
}

// Güncelleme sil
if (isAdminLoggedIn() && isset($_GET['delete'])) {
    $data = getUpdates();
    $version = $_GET['delete'];
    
    foreach ($data['updates'] as $k => $u) {
        if ($u['version'] === $version) {
            // Dosyayı sil
            if (!empty($u['filename']) && file_exists(UPDATES_DIR . '/' . $u['filename'])) {
                unlink(UPDATES_DIR . '/' . $u['filename']);
            }
            unset($data['updates'][$k]);
            break;
        }
    }
    
    $data['updates'] = array_values($data['updates']);
    
    // En son versiyonu bul
    $latestVersion = '1.0.0';
    foreach ($data['updates'] as $u) {
        if (versionCompare($u['version'], $latestVersion) > 0) {
            $latestVersion = $u['version'];
        }
    }
    $data['latest_version'] = $latestVersion;
    
    saveUpdates($data);
    header('Location: index.php?deleted=1');
    exit;
}

$data = getUpdates();
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>QR Menü - Güncelleme Sunucusu</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <style>
        body { background: #f5f5f5; }
        .login-box { max-width: 400px; margin: 100px auto; }
        .admin-header { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); }
    </style>
</head>
<body>
    <?php if (!isAdminLoggedIn()): ?>
    <!-- Login Form -->
    <div class="login-box">
        <div class="card shadow">
            <div class="card-header bg-primary text-white text-center">
                <h4 class="mb-0"><i class="fas fa-server me-2"></i>Güncelleme Sunucusu</h4>
            </div>
            <div class="card-body">
                <?php if (isset($error)): ?>
                <div class="alert alert-danger"><?php echo $error; ?></div>
                <?php endif; ?>
                
                <form method="POST">
                    <div class="mb-3">
                        <label class="form-label">Yönetici Şifresi</label>
                        <input type="password" name="password" class="form-control" required autofocus>
                    </div>
                    <button type="submit" name="login" class="btn btn-primary w-100">
                        <i class="fas fa-sign-in-alt me-2"></i>Giriş Yap
                    </button>
                </form>
            </div>
        </div>
    </div>
    
    <?php else: ?>
    <!-- Admin Panel -->
    <nav class="navbar navbar-expand-lg navbar-dark admin-header">
        <div class="container">
            <a class="navbar-brand" href="#">
                <i class="fas fa-server me-2"></i>QR Menü Güncelleme Sunucusu
            </a>
            <div class="d-flex">
                <span class="text-white me-3">
                    <i class="fas fa-code-branch me-1"></i>En son: v<?php echo $data['latest_version']; ?>
                </span>
                <a href="?logout=1" class="btn btn-outline-light btn-sm">
                    <i class="fas fa-sign-out-alt"></i> Çıkış
                </a>
            </div>
        </div>
    </nav>
    
    <div class="container py-4">
        <?php if (isset($success)): ?>
        <div class="alert alert-success alert-dismissible fade show">
            <?php echo $success; ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
        <?php endif; ?>
        
        <?php if (isset($_GET['deleted'])): ?>
        <div class="alert alert-success alert-dismissible fade show">
            Güncelleme silindi.
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
        <?php endif; ?>
        
        <div class="row">
            <div class="col-lg-5">
                <!-- Yeni Güncelleme Formu -->
                <div class="card mb-4">
                    <div class="card-header bg-success text-white">
                        <h5 class="mb-0"><i class="fas fa-plus me-2"></i>Yeni Güncelleme Ekle</h5>
                    </div>
                    <div class="card-body">
                        <form method="POST" enctype="multipart/form-data">
                            <div class="mb-3">
                                <label class="form-label">Versiyon *</label>
                                <input type="text" name="version" class="form-control" required placeholder="3.1.0">
                            </div>
                            
                            <div class="mb-3">
                                <label class="form-label">Açıklama</label>
                                <input type="text" name="description" class="form-control" placeholder="Kısa açıklama">
                            </div>
                            
                            <div class="mb-3">
                                <label class="form-label">Değişiklik Listesi</label>
                                <textarea name="changelog" class="form-control" rows="4" placeholder="Her satıra bir değişiklik"></textarea>
                            </div>
                            
                            <div class="mb-3">
                                <label class="form-label">Güncelleme Dosyası (ZIP)</label>
                                <input type="file" name="update_file" class="form-control" accept=".zip">
                            </div>
                            
                            <div class="form-check mb-3">
                                <input type="checkbox" name="is_critical" class="form-check-input" id="is_critical">
                                <label class="form-check-label" for="is_critical">Kritik Güncelleme</label>
                            </div>
                            
                            <button type="submit" name="add_update" class="btn btn-success w-100">
                                <i class="fas fa-upload me-2"></i>Güncelleme Yükle
                            </button>
                        </form>
                    </div>
                </div>
            </div>
            
            <div class="col-lg-7">
                <!-- Mevcut Güncellemeler -->
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0"><i class="fas fa-list me-2"></i>Mevcut Güncellemeler</h5>
                    </div>
                    <div class="card-body">
                        <?php if (empty($data['updates'])): ?>
                        <div class="text-center text-muted py-4">
                            <i class="fas fa-inbox fa-3x mb-3"></i>
                            <p>Henüz güncelleme yok</p>
                        </div>
                        <?php else: ?>
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>Versiyon</th>
                                        <th>Açıklama</th>
                                        <th>Tarih</th>
                                        <th>Boyut</th>
                                        <th></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach (array_reverse($data['updates']) as $update): ?>
                                    <tr>
                                        <td>
                                            <span class="badge bg-<?php echo ($update['version'] === $data['latest_version']) ? 'success' : 'secondary'; ?>">
                                                v<?php echo htmlspecialchars($update['version']); ?>
                                            </span>
                                            <?php if (!empty($update['is_critical'])): ?>
                                            <span class="badge bg-danger">Kritik</span>
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo htmlspecialchars($update['description'] ?? '-'); ?></td>
                                        <td><?php echo date('d.m.Y', strtotime($update['release_date'])); ?></td>
                                        <td><?php echo $update['file_size'] ? number_format($update['file_size'] / 1024, 1) . ' KB' : '-'; ?></td>
                                        <td>
                                            <a href="?delete=<?php echo urlencode($update['version']); ?>" 
                                               class="btn btn-sm btn-outline-danger"
                                               onclick="return confirm('Silmek istediğinize emin misiniz?')">
                                                <i class="fas fa-trash"></i>
                                            </a>
                                        </td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
                
                <!-- API Bilgisi -->
                <div class="card mt-4">
                    <div class="card-header">
                        <h5 class="mb-0"><i class="fas fa-code me-2"></i>API Endpoints</h5>
                    </div>
                    <div class="card-body">
                        <table class="table table-sm">
                            <tr>
                                <td><code>GET /api/updates/check.php?version=X.X.X</code></td>
                                <td>Güncelleme kontrolü</td>
                            </tr>
                            <tr>
                                <td><code>GET /api/updates/download.php?version=X.X.X</code></td>
                                <td>Güncelleme indir</td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
