<?php
/**
 * Güncelleme Kontrol API
 * qr.yusuf.net.tr/api/updates/check.php
 */

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');

require_once __DIR__ . '/../../config.php';

$currentVersion = $_GET['version'] ?? '1.0.0';

$data = getUpdates();
$latestVersion = $data['latest_version'] ?? '3.0.0';

// Versiyon kontrolü
if (versionCompare($currentVersion, $latestVersion) >= 0) {
    // Güncel
    echo json_encode([
        'success' => true,
        'update_available' => false,
        'current_version' => $currentVersion,
        'latest_version' => $latestVersion,
        'message' => 'Sisteminiz güncel!'
    ]);
    exit;
}

// Güncelleme mevcut
$update = null;
foreach ($data['updates'] as $u) {
    if ($u['version'] === $latestVersion) {
        $update = $u;
        break;
    }
}

if (!$update) {
    echo json_encode([
        'success' => false,
        'error' => 'Güncelleme bilgisi bulunamadı'
    ]);
    exit;
}

echo json_encode([
    'success' => true,
    'update_available' => true,
    'current_version' => $currentVersion,
    'latest_version' => $latestVersion,
    'description' => $update['description'] ?? '',
    'changelog' => $update['changelog'] ?? '',
    'release_date' => $update['release_date'] ?? '',
    'download_url' => $update['download_url'] ?? '',
    'file_size' => $update['file_size'] ?? 0,
    'min_php_version' => $update['min_php_version'] ?? '7.4',
    'is_critical' => $update['is_critical'] ?? false
]);
