<?php
/**
 * Güncelleme İndirme API
 * qr.yusuf.net.tr/api/updates/download.php
 */

require_once __DIR__ . '/../../config.php';

$version = $_GET['version'] ?? '';

if (empty($version)) {
    header('HTTP/1.1 400 Bad Request');
    echo json_encode(['error' => 'Versiyon belirtilmedi']);
    exit;
}

$data = getUpdates();
$update = null;

foreach ($data['updates'] as $u) {
    if ($u['version'] === $version) {
        $update = $u;
        break;
    }
}

if (!$update) {
    header('HTTP/1.1 404 Not Found');
    echo json_encode(['error' => 'Güncelleme bulunamadı']);
    exit;
}

$filePath = UPDATES_DIR . '/' . $update['filename'];

if (!file_exists($filePath)) {
    header('HTTP/1.1 404 Not Found');
    echo json_encode(['error' => 'Güncelleme dosyası bulunamadı']);
    exit;
}

// İndirme logunu kaydet
$logFile = __DIR__ . '/../../downloads.log';
$logEntry = date('Y-m-d H:i:s') . ' | ' . $version . ' | ' . ($_SERVER['REMOTE_ADDR'] ?? 'unknown') . "\n";
file_put_contents($logFile, $logEntry, FILE_APPEND);

// Dosyayı gönder
header('Content-Type: application/zip');
header('Content-Disposition: attachment; filename="qrmenu-' . $version . '.zip"');
header('Content-Length: ' . filesize($filePath));
header('Cache-Control: no-cache, must-revalidate');

readfile($filePath);
exit;
