<?php
/**
 * QR Menü Güncelleme Sunucusu
 * Bu dosyaları qr.yusuf.net.tr sunucusuna yükleyin
 * 
 * Dizin Yapısı:
 * /api/updates/check.php - Güncelleme kontrol API
 * /api/updates/download.php - Güncelleme indirme API
 * /updates/ - Güncelleme ZIP dosyaları
 * /admin/ - Yönetim paneli
 * config.php - Yapılandırma
 */

// Temel Ayarlar
define('UPDATE_SERVER', true);
define('ADMIN_PASSWORD', 'admin123'); // DEĞİŞTİRİN!
define('UPDATES_DIR', __DIR__ . '/updates');
define('UPDATES_JSON', __DIR__ . '/updates.json');

// Session
session_start();

// Güncellemeler dosyası yoksa oluştur
if (!file_exists(UPDATES_JSON)) {
    file_put_contents(UPDATES_JSON, json_encode([
        'updates' => [],
        'latest_version' => '3.0.0'
    ], JSON_PRETTY_PRINT));
}

// Güncellemeler dizini yoksa oluştur
if (!is_dir(UPDATES_DIR)) {
    mkdir(UPDATES_DIR, 0755, true);
}

/**
 * Güncelleme bilgilerini al
 */
function getUpdates() {
    if (!file_exists(UPDATES_JSON)) {
        return ['updates' => [], 'latest_version' => '3.0.0'];
    }
    return json_decode(file_get_contents(UPDATES_JSON), true);
}

/**
 * Güncelleme bilgilerini kaydet
 */
function saveUpdates($data) {
    file_put_contents(UPDATES_JSON, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
}

/**
 * Versiyon karşılaştır
 */
function versionCompare($v1, $v2) {
    return version_compare($v1, $v2);
}

/**
 * Admin giriş kontrolü
 */
function isAdminLoggedIn() {
    return isset($_SESSION['update_admin']) && $_SESSION['update_admin'] === true;
}
